# conda create -n mp3toyoutube python=3.7.4
# conda activate mp3toyoutube
# pip install ffmpeg
# pip install Pillow==9.5.0

from PIL import Image, ImageDraw, ImageFont
import subprocess
import sys

def convert_to_mp4(audio_file):
    # Create the background image
    #create_background_image(audio_file)
    
    # Prepare output filename
    output_file = audio_file.rsplit('.', 1)[0] + '.mp4'
    
    # Use FFmpeg to combine the image and audio into an MP4
    command = [
        'ffmpeg',
        '-loop', '1',
        '-i', 'background.png',
        '-i', audio_file,
        '-c:v', 'libx264',
        '-tune', 'stillimage',
        '-c:a', 'aac',
        '-b:a', '320k',
        '-pix_fmt', 'yuv420p',
        '-shortest',
        output_file
    ]
    subprocess.run(command)

if __name__ == "__main__":
    # Take the audio file name from the command line argument
    audio_file = sys.argv[1]
    convert_to_mp4(audio_file)
